
var config = {
        address: "%1$s",
        chainId: %3$s,
        rpcUrl: "%2$s"
};
const taiji_uuidString = "%4$s";
const taiji_signString = "%5$s";
function getTaijiUUID () { return taiji_uuidString }
function getTaijiSign () { return taiji_signString }


function getTaijiChainID () { return config.chainId; }
    const provider = new window.Trust(config);
    window.ethereum = provider;
    provider.postMessage = function(handler, id, data) {
    console.debug("收到的消息"+handler);
      switch (handler) {
        case 'signTransaction':
          var gasLimit = data.gasLimit || data.gas || null;
          var gasPrice = data.gasPrice || null;
          var nonce = data.nonce || -1;
          return trust.signTransaction(id, data.to || null, data.value, nonce, gasLimit, gasPrice, data.data || null);
        case 'signMessage':
          return trust.signMessage(id, data.data);
        case 'signPersonalMessage':
          return trust.signPersonalMessage(id, data.data);
        case 'signTypedMessage':
        case 'eth_signTypedData_v3':
          return trust.signTypedMessage(id, JSON.stringify(data.data));
        case 'requestAccounts':
        case 'eth_requestAccounts':
          return trust.requestAccounts(id, "{}");
        case 'ecRecover':
          return trust.ecRecover(data.signature, data.message, id);
      case 'eth_chainId':
          return window.ethereum.sendResponse(id, "0x" + config.chainId.toString(16));
      }
    };
    window.web3 = new window.Web3(provider);
    window.web3.eth.defaultAccount = config.address;
    window.chrome = {webstore: {}};

